/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.type;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.chisel.ctm.api.texture.ITextureType;
import team.chisel.ctm.api.texture.TextureType;

public final class TextureTypeRegistry {
    private static final Logger log = LogManager.getLogger(TextureTypeRegistry.class);
    private static Map<String, ITextureType> map = Maps.newHashMap();

    public static void scan() {
        List<ModFileScanData.AnnotationData> annotations = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> TextureType.class.getName().equals(a.annotationType().getClassName())).toList();
        log.debug("Found {} @TextureType annotations from scan", (Object)annotations.size());
        HashMultimap annots = HashMultimap.create();
        for (ModFileScanData.AnnotationData annotationData : annotations) {
            annots.put((Object)annotationData, (Object)((String)annotationData.annotationData().get("value")));
        }
        log.debug("Found {} unique texture types", (Object)annots.size());
        for (Map.Entry entry : annots.asMap().entrySet()) {
            ITextureType type;
            if (((ModFileScanData.AnnotationData)entry.getKey()).targetType() == ElementType.FIELD) {
                try {
                    Class<?> c = Class.forName(((ModFileScanData.AnnotationData)entry.getKey()).clazz().getClassName());
                    Field f = c.getDeclaredField(((ModFileScanData.AnnotationData)entry.getKey()).memberName());
                    type = (ITextureType)f.get(null);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception loading texture type for class: " + ((ModFileScanData.AnnotationData)entry.getKey()).clazz(), e);
                }
            } else if (((ModFileScanData.AnnotationData)entry.getKey()).targetType() == ElementType.TYPE) {
                try {
                    Class<?> clazz = Class.forName(((ModFileScanData.AnnotationData)entry.getKey()).clazz().getClassName());
                    type = (ITextureType)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception loading texture type for class: " + ((ModFileScanData.AnnotationData)entry.getKey()).clazz() + " (on member " + ((ModFileScanData.AnnotationData)entry.getKey()).memberName() + ")", e);
                }
            } else {
                throw new IllegalArgumentException("@TextureType found on invalid element type: " + ((ModFileScanData.AnnotationData)entry.getKey()).targetType() + " (" + ((ModFileScanData.AnnotationData)entry.getKey()).clazz() + ")");
            }
            for (String name : (Collection)entry.getValue()) {
                log.debug("Registering scanned texture type: {}", (Object)name);
                TextureTypeRegistry.register(name, type);
            }
        }
    }

    public static void register(String name, ITextureType type) {
        String key = name.toLowerCase(Locale.ROOT);
        if (map.containsKey(key) && map.get(key) != type) {
            throw new IllegalArgumentException("Render Type with name " + key + " has already been registered!");
        }
        if (map.get(key) != type) {
            map.put(key, type);
        }
    }

    public static ITextureType getType(String name) {
        String key = name.toLowerCase(Locale.ROOT);
        return map.get(key);
    }

    public static boolean isValid(String name) {
        return TextureTypeRegistry.getType(name) != null;
    }

    private TextureTypeRegistry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

