/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.data.recipes.potinteraction.PotInteraction;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.darkhax.botanypots.events.BotanyPotEventDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BotanyPotHelper {
    public static final CachedSupplier<RecipeType<Soil>> SOIL_TYPE = RegistryObject.deferred((Registry)Registry.f_122864_, (String)"botanypots", (String)"soil").cast();
    public static final CachedSupplier<RecipeSerializer<?>> SOIL_SERIALIZER = RegistryObject.deferred((Registry)Registry.f_122865_, (String)"botanypots", (String)"soil").cast();
    public static final CachedSupplier<RecipeType<Crop>> CROP_TYPE = RegistryObject.deferred((Registry)Registry.f_122864_, (String)"botanypots", (String)"crop").cast();
    public static final CachedSupplier<RecipeSerializer<?>> CROP_SERIALIZER = RegistryObject.deferred((Registry)Registry.f_122865_, (String)"botanypots", (String)"crop").cast();
    public static final CachedSupplier<RecipeType<PotInteraction>> POT_INTERACTION_TYPE = RegistryObject.deferred((Registry)Registry.f_122864_, (String)"botanypots", (String)"pot_interaction").cast();
    public static final CachedSupplier<RecipeSerializer<?>> SIMPLE_POT_INTERACTION_SERIALIZER = RegistryObject.deferred((Registry)Registry.f_122865_, (String)"botanypots", (String)"pot_interaction").cast();
    public static final CachedSupplier<RecipeType<Fertilizer>> FERTILIZER_TYPE = RegistryObject.deferred((Registry)Registry.f_122864_, (String)"botanypots", (String)"fertilizer").cast();
    public static final CachedSupplier<RecipeSerializer<?>> BASIC_FERTILIZER_SERIALIZER = RegistryObject.deferred((Registry)Registry.f_122865_, (String)"botanypots", (String)"fertilizer").cast();
    public static final BotanyPotEventDispatcher EVENT_DISPATCHER = (BotanyPotEventDispatcher)Services.load(BotanyPotEventDispatcher.class);

    public static int getRequiredGrowthTicks(Level level, BlockPos pos, BlockEntityBotanyPot pot, @Nullable Crop crop, @Nullable Soil soil) {
        if (crop == null || soil == null) {
            return -1;
        }
        float requiredGrowthTicks = crop.getGrowthTicks(level, pos, pot, soil);
        float growthModifier = soil.getGrowthModifier(level, pos, pot, crop);
        if (growthModifier >= 0.0f) {
            return Mth.m_14143_((float)(requiredGrowthTicks / growthModifier));
        }
        return -1;
    }

    public static boolean canCropGrow(Level level, BlockPos pos, BlockEntityBotanyPot pot, Soil soil, Crop crop) {
        if (soil == null || crop == null) {
            return false;
        }
        return soil.canGrowCrop(level, pos, pot, crop) && crop.canGrowInSoil(level, pos, pot, soil);
    }

    @Nullable
    public static Soil findSoil(Level level, BlockPos pos, BlockEntityBotanyPot pot, ItemStack soilStack) {
        Soil result = null;
        if (level != null && !soilStack.m_41619_()) {
            for (Soil soil : BotanyPotHelper.getAllRecipes(level.m_7465_(), (RecipeType)SOIL_TYPE.get())) {
                if (!soil.matchesLookup(level, pos, pot, soilStack)) continue;
                result = soil;
                break;
            }
        }
        return EVENT_DISPATCHER.postSoilLookup(level, pos, pot, soilStack, result);
    }

    @Nullable
    public static Crop findCrop(Level level, BlockPos pos, BlockEntityBotanyPot pot, ItemStack stack) {
        Crop result = null;
        if (level != null && !stack.m_41619_()) {
            for (Crop crop : BotanyPotHelper.getAllRecipes(level.m_7465_(), (RecipeType)CROP_TYPE.get())) {
                if (!crop.matchesLookup(level, pos, pot, stack)) continue;
                result = crop;
                break;
            }
        }
        return EVENT_DISPATCHER.postCropLookup(level, pos, pot, stack, result);
    }

    public static <C extends Container, T extends Recipe<C>> List<T> getAllRecipes(RecipeManager manager, RecipeType<T> type) {
        return manager.m_44013_(type);
    }

    @Nullable
    public static PotInteraction findPotInteraction(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldStack, BlockEntityBotanyPot pot) {
        PotInteraction result = null;
        if (!heldStack.m_41619_()) {
            for (PotInteraction interaction : BotanyPotHelper.getAllRecipes(world.m_7465_(), (RecipeType)POT_INTERACTION_TYPE.get())) {
                if (!interaction.canApply(state, world, pos, player, hand, heldStack, pot)) continue;
                result = interaction;
                break;
            }
        }
        return EVENT_DISPATCHER.postInteractionLookup(state, world, pos, player, hand, heldStack, pot, result);
    }

    @Nullable
    public static Fertilizer findFertilizer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldStack, BlockEntityBotanyPot pot) {
        Fertilizer result = null;
        if (!heldStack.m_41619_()) {
            for (Fertilizer fertilizer : BotanyPotHelper.getAllRecipes(world.m_7465_(), (RecipeType)FERTILIZER_TYPE.get())) {
                if (!fertilizer.canApply(state, world, pos, player, hand, heldStack, pot)) continue;
                result = fertilizer;
                break;
            }
        }
        return EVENT_DISPATCHER.postFertilizerLookup(state, world, pos, player, hand, heldStack, pot, result);
    }

    public static List<ItemStack> generateDrop(Random rng, Level level, BlockPos pos, BlockEntityBotanyPot pot, Crop crop) {
        return EVENT_DISPATCHER.postCropDrops(rng, level, pos, pot, crop, crop.generateDrops(rng, level, pos, pot));
    }
}

