/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.item.relic.RelicItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class EyeOfTheFlugelItem
extends RelicItem {
    private static final String TAG_TARGET_PREFIX = "target_";

    public EyeOfTheFlugelItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        if (player != null && player.m_36341_()) {
            if (world.f_46443_) {
                for (int i = 0; i < 10; ++i) {
                    float x1 = (float)((double)pos.m_123341_() + Math.random());
                    float y1 = pos.m_123342_() + 1;
                    float z1 = (float)((double)pos.m_123343_() + Math.random());
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.5f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
                    world.m_7106_((ParticleOptions)data, (double)x1, (double)y1, (double)z1, 0.0, (double)(0.05f - (float)Math.random() * 0.05f), 0.0);
                }
            } else {
                ItemStack stack = ctx.m_43722_();
                Tag nbt = (Tag)BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pos).get().orThrow();
                ItemNBTHelper.set(stack, TAG_TARGET_PREFIX + world.m_46472_().m_135782_(), nbt);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.flugelEyeBind, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_5929_(Level world, LivingEntity living, ItemStack stack, int count) {
        if (world.f_46443_) {
            float x = (float)(living.m_20185_() - Math.random() * (double)living.m_20205_());
            float y = (float)(living.m_20186_() + Math.random());
            float z = (float)(living.m_20189_() - Math.random() * (double)living.m_20205_());
            WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.7f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
            world.m_7106_((ParticleOptions)data, (double)x, (double)y, (double)z, 0.0, (double)(0.05f + (float)Math.random() * 0.05f), 0.0);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, Level world, LivingEntity living) {
        block6: {
            int z;
            int y;
            int x;
            block5: {
                String tag = TAG_TARGET_PREFIX + world.m_46472_().m_135782_();
                Tag nbt = ItemNBTHelper.get(stack, tag);
                if (nbt == null) {
                    return stack;
                }
                Optional maybeLoc = BlockPos.f_121852_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).result();
                if (!maybeLoc.isPresent()) {
                    ItemNBTHelper.removeEntry(stack, tag);
                    return stack;
                }
                BlockPos loc = (BlockPos)maybeLoc.get();
                x = loc.m_123341_();
                y = loc.m_123342_();
                z = loc.m_123343_();
                int cost = (int)(MathHelper.pointDistanceSpace((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, living.m_20185_(), living.m_20186_(), living.m_20189_()) * 10.0f);
                if (!(living instanceof Player)) break block5;
                Player player = (Player)living;
                if (!ManaItemHandler.instance().requestManaExact(stack, player, cost, true)) break block6;
            }
            EyeOfTheFlugelItem.moveParticlesAndSound((Entity)living);
            living.m_6021_((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
            EyeOfTheFlugelItem.moveParticlesAndSound((Entity)living);
        }
        return stack;
    }

    private static void moveParticlesAndSound(Entity entity) {
        XplatAbstractions.INSTANCE.sendToTracking(entity, new BotaniaEffectPacket(EffectType.FLUGEL_EFFECT, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_19879_()));
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), BotaniaSounds.flugelEyeTeleport, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public int m_8105_(ItemStack stack) {
        return 40;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        if (world == null) {
            return;
        }
        CoordBoundItem coordBoundItem = XplatAbstractions.INSTANCE.findCoordBoundItem(stack);
        if (coordBoundItem == null) {
            return;
        }
        BlockPos binding = coordBoundItem.getBinding(world);
        MutableComponent worldText = Component.m_237113_((String)world.m_46472_().m_135782_().toString()).m_130940_(ChatFormatting.GREEN);
        if (binding == null) {
            tooltip.add((Component)Component.m_237110_((String)"botaniamisc.flugelUnbound", (Object[])new Object[]{worldText}).m_130940_(ChatFormatting.GRAY));
        } else {
            MutableComponent bindingText = Component.m_237113_((String)"[").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)Integer.toString(binding.m_123341_())).m_130940_(ChatFormatting.GOLD)).m_130946_(", ").m_7220_((Component)Component.m_237113_((String)Integer.toString(binding.m_123342_())).m_130940_(ChatFormatting.GOLD)).m_130946_(", ").m_7220_((Component)Component.m_237113_((String)Integer.toString(binding.m_123343_())).m_130940_(ChatFormatting.GOLD)).m_130946_("]");
            tooltip.add((Component)Component.m_237110_((String)"botaniamisc.flugelBound", (Object[])new Object[]{bindingText, worldText}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("challenge/flugel_eye"));
    }

    public static class CoordBoundItemImpl
    implements CoordBoundItem {
        private final ItemStack stack;

        public CoordBoundItemImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public BlockPos getBinding(Level world) {
            String tag = EyeOfTheFlugelItem.TAG_TARGET_PREFIX + world.m_46472_().m_135782_();
            Tag nbt = ItemNBTHelper.get(this.stack, tag);
            if (nbt != null) {
                return BlockPos.f_121852_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).result().orElse(null);
            }
            return null;
        }
    }
}

