/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.brew;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewContainer;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.brew.BaseBrewItem;

public class IncenseStickItem
extends Item
implements BrewItem,
BrewContainer {
    private static final String TAG_BREW_KEY = "brewKey";
    public static final int TIME_MULTIPLIER = 60;

    public IncenseStickItem(Item.Properties builder) {
        super(builder);
    }

    public void m_6787_(@NotNull CreativeModeTab tab, @NotNull NonNullList<ItemStack> list) {
        super.m_6787_(tab, list);
        if (this.m_220152_(tab)) {
            for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
                ItemStack brewStack = this.getItemForBrew(brew, new ItemStack((ItemLike)this));
                if (brewStack.m_41619_()) continue;
                list.add((Object)brewStack);
            }
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        Brew brew = this.getBrew(stack);
        if (brew == BotaniaBrews.fallbackBrew) {
            list.add((Component)Component.m_237115_((String)"botaniamisc.notInfused").m_130940_(ChatFormatting.LIGHT_PURPLE));
            return;
        }
        list.add((Component)Component.m_237110_((String)"botaniamisc.brewOf", (Object[])new Object[]{Component.m_237115_((String)brew.getTranslationKey(stack))}).m_130940_(ChatFormatting.LIGHT_PURPLE));
        BaseBrewItem.addPotionTooltip(brew.getPotionEffects(stack), list, 60.0f);
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return (Brew)BotaniaAPI.instance().getBrewRegistry().m_7745_(ResourceLocation.m_135820_((String)key));
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        IncenseStickItem.setBrew(stack, BotaniaAPI.instance().getBrewRegistry().m_7981_((Object)brew));
    }

    public static void setBrew(ItemStack stack, ResourceLocation brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew.toString());
    }

    @Override
    public ItemStack getItemForBrew(Brew brew, ItemStack stack) {
        if (!brew.canInfuseIncense() || brew.getPotionEffects(stack).size() != 1 || brew.getPotionEffects(stack).get(0).m_19544_().m_8093_()) {
            return ItemStack.f_41583_;
        }
        ItemStack brewStack = new ItemStack((ItemLike)this);
        IncenseStickItem.setBrew(brewStack, brew);
        return brewStack;
    }

    @Override
    public int getManaCost(Brew brew, ItemStack stack) {
        return brew.getManaCost() * 10;
    }
}

