/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.xplat.BotaniaConfig;

public class ClayconiaBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int COST = 80;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;
    private static final int RANGE_MINI = 2;
    private static final int RANGE_Y_MINI = 1;

    protected ClayconiaBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ClayconiaBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.CLAYCONIA, pos, state);
    }

    @Override
    public void tickFlower() {
        BlockPos coords;
        super.tickFlower();
        if (!this.m_58904_().f_46443_ && this.ticksExisted % 5 == 0 && this.getMana() >= 80 && (coords = this.getCoordsToPut()) != null) {
            int stateId = Block.m_49956_((BlockState)this.m_58904_().m_8055_(coords));
            this.m_58904_().m_7471_(coords, false);
            if (BotaniaConfig.common().blockBreakParticles()) {
                this.m_58904_().m_46796_(2001, coords, stateId);
            }
            ItemEntity item = new ItemEntity(this.m_58904_(), (double)coords.m_123341_() + 0.5, (double)coords.m_123342_() + 0.5, (double)coords.m_123343_() + 0.5, new ItemStack((ItemLike)Items.f_42461_));
            this.m_58904_().m_7967_((Entity)item);
            this.addMana(-80);
        }
    }

    public BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        int range = this.getRange();
        int rangeY = this.getRangeY();
        for (int i = -range; i < range + 1; ++i) {
            for (int j = -rangeY; j < rangeY + 1; ++j) {
                for (int k = -range; k < range + 1; ++k) {
                    BlockPos pos = this.getEffectivePos().m_7918_(i, j, k);
                    BlockState state = this.m_58904_().m_8055_(pos);
                    if (!state.m_204336_(BlockTags.f_13029_)) continue;
                    possibleCoords.add(pos);
                }
            }
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.m_58904_().f_46441_.m_188503_(possibleCoords.size()));
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    public int getRange() {
        return 5;
    }

    public int getRangeY() {
        return 3;
    }

    @Override
    public int getColor() {
        return 8095634;
    }

    @Override
    public int getMaxMana() {
        return 640;
    }

    public static class Mini
    extends ClayconiaBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.CLAYCONIA_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return 2;
        }

        @Override
        public int getRangeY() {
            return 1;
        }
    }
}

