/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model.armor;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.armor.ArmorModel;
import vazkii.botania.common.item.equipment.armor.elementium.ElementiumArmorItem;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;
import vazkii.botania.common.item.equipment.armor.manaweave.ManaweaveArmorItem;
import vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelArmorItem;

public class ArmorModels {
    private static Map<EquipmentSlot, ArmorModel> manasteel = Collections.emptyMap();
    private static Map<EquipmentSlot, ArmorModel> manaweave = Collections.emptyMap();
    private static Map<EquipmentSlot, ArmorModel> elementium = Collections.emptyMap();
    private static Map<EquipmentSlot, ArmorModel> terrasteel = Collections.emptyMap();

    private static Map<EquipmentSlot, ArmorModel> make(EntityRendererProvider.Context ctx, ModelLayerLocation inner, ModelLayerLocation outer) {
        EnumMap<EquipmentSlot, ArmorModel> ret = new EnumMap<EquipmentSlot, ArmorModel>(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ModelPart mesh = ctx.m_174023_(slot == EquipmentSlot.LEGS ? inner : outer);
            ret.put(slot, new ArmorModel(mesh, slot));
        }
        return ret;
    }

    public static void init(EntityRendererProvider.Context ctx) {
        manasteel = ArmorModels.make(ctx, BotaniaModelLayers.MANASTEEL_INNER_ARMOR, BotaniaModelLayers.MANASTEEL_OUTER_ARMOR);
        manaweave = ArmorModels.make(ctx, BotaniaModelLayers.MANAWEAVE_INNER_ARMOR, BotaniaModelLayers.MANAWEAVE_OUTER_ARMOR);
        elementium = ArmorModels.make(ctx, BotaniaModelLayers.ELEMENTIUM_INNER_ARMOR, BotaniaModelLayers.ELEMENTIUM_OUTER_ARMOR);
        terrasteel = ArmorModels.make(ctx, BotaniaModelLayers.TERRASTEEL_INNER_ARMOR, BotaniaModelLayers.TERRASTEEL_OUTER_ARMOR);
    }

    @Nullable
    public static ArmorModel get(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ManaweaveArmorItem) {
            ManaweaveArmorItem armor = (ManaweaveArmorItem)item;
            return manaweave.get(armor.m_40402_());
        }
        if (item instanceof ElementiumArmorItem) {
            ElementiumArmorItem armor = (ElementiumArmorItem)item;
            return elementium.get(armor.m_40402_());
        }
        if (item instanceof TerrasteelArmorItem) {
            TerrasteelArmorItem armor = (TerrasteelArmorItem)item;
            return terrasteel.get(armor.m_40402_());
        }
        if (item instanceof ManasteelArmorItem) {
            ManasteelArmorItem armor = (ManasteelArmorItem)item;
            return manasteel.get(armor.m_40402_());
        }
        return null;
    }
}

