/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.entity.ai.goal.FollowTypeSchoolLeaderGoal;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class AquaFishEntity
extends AbstractSchoolingFish {
    private final FishType fishType;

    public AquaFishEntity(EntityType<? extends AbstractSchoolingFish> entityType, Level world, FishType fishType) {
        super(entityType, world);
        this.fishType = fishType;
    }

    public FishType getFishType() {
        return this.fishType;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_().getClass() == FollowFlockLeaderGoal.class) {
                this.f_21345_.m_25363_(prioritizedGoal.m_26015_());
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FollowTypeSchoolLeaderGoal(this));
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.m_28282_();
    }

    @Nonnull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_()).toString() + "_bucket")));
    }

    @Nonnull
    protected SoundEvent m_5699_() {
        if (this.getFishType() == FishType.JELLYFISH) {
            return (SoundEvent)AquaSounds.JELLYFISH_FLOP.get();
        }
        return (SoundEvent)AquaSounds.FISH_FLOP.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AquaSounds.FISH_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AquaSounds.FISH_DEATH.get();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AquaSounds.FISH_HURT.get();
    }

    @Nonnull
    public EntityDimensions m_6972_(@Nonnull Pose pose) {
        return super.m_6972_(pose);
    }

    public void m_6123_(@Nonnull Player player) {
        super.m_6123_(player);
        if (Objects.equals(ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_()), new ResourceLocation("aquaculture", "jellyfish")) && this.m_6084_() && this.m_20280_((Entity)player) < 1.0 && player.m_6469_(DamageSource.m_19370_((LivingEntity)this), 0.5f)) {
            this.m_5496_((SoundEvent)AquaSounds.JELLYFISH_COLLIDE.get(), 0.5f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19970_((LivingEntity)this, (Entity)player);
        }
    }

    public void m_27541_() {
        if (this.f_27520_ != null) {
            super.m_27541_();
        }
    }

    public static boolean canSpawnHere(EntityType<? extends AbstractFish> fish, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        int seaLevel = world.m_5736_();
        int minY = seaLevel - 13;
        boolean isAllNeighborsSource = AquaFishEntity.isSourceBlock(world, pos.m_122012_()) && AquaFishEntity.isSourceBlock(world, pos.m_122019_()) && AquaFishEntity.isSourceBlock(world, pos.m_122024_()) && AquaFishEntity.isSourceBlock(world, pos.m_122029_());
        return AquaFishEntity.isSourceBlock(world, pos) && isAllNeighborsSource && pos.m_123342_() >= minY && pos.m_123342_() <= seaLevel;
    }

    private static boolean isSourceBlock(LevelAccessor world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof LiquidBlock && world.m_8055_(pos).m_60713_(Blocks.f_49990_) && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
    }
}

