/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.util;

import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;

public interface ChemicalBridge {
    public static <S extends ChemicalStack<?>> S withAmount(S stack, long amount) {
        if (stack instanceof GasStack) {
            GasStack gas = (GasStack)stack;
            return (S)new GasStack(gas, amount);
        }
        if (stack instanceof InfusionStack) {
            InfusionStack infusion = (InfusionStack)stack;
            return (S)new InfusionStack(infusion, amount);
        }
        if (stack instanceof PigmentStack) {
            PigmentStack pigment = (PigmentStack)stack;
            return (S)new PigmentStack(pigment, amount);
        }
        if (stack instanceof SlurryStack) {
            SlurryStack slurry = (SlurryStack)stack;
            return (S)new SlurryStack(slurry, amount);
        }
        throw new UnsupportedOperationException();
    }
}

