/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.yogpc.qp.utils.SupplierCacheEntry;
import java.util.function.Supplier;
import net.minecraft.world.level.Level;

public abstract class CacheEntry<T> {
    protected long lastUpdateTime = 0L;
    protected final long cacheInterval;
    protected T cached;

    protected CacheEntry(long cacheInterval) {
        this.cacheInterval = cacheInterval;
    }

    public T getValue(long currentTime) {
        if (currentTime - this.lastUpdateTime >= this.cacheInterval || this.cached == null) {
            this.setNewCache();
            this.lastUpdateTime = currentTime;
        }
        return this.cached;
    }

    public T getValue(Level level) {
        if (level == null) {
            return this.getValue(0L);
        }
        return this.getValue(level.m_46467_());
    }

    protected abstract void setNewCache();

    public void expire() {
        this.cached = null;
    }

    public String toString() {
        return "CacheEntry{cached=" + this.cached + "}";
    }

    public static <T> CacheEntry<T> supplierCache(long cacheInterval, Supplier<T> supplier) {
        return new SupplierCacheEntry<T>(cacheInterval, supplier);
    }
}

