/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.yogpc.qp.machines.workbench.DefaultFinder;
import com.yogpc.qp.machines.workbench.DummyRecipe;
import com.yogpc.qp.machines.workbench.IngredientList;
import com.yogpc.qp.machines.workbench.RecipeFinder;
import com.yogpc.qp.machines.workbench.TileWorkbench;
import com.yogpc.qp.machines.workbench.WorkbenchRecipeSerializer;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class WorkbenchRecipe
implements Recipe<TileWorkbench> {
    public static final ResourceLocation recipeLocation = new ResourceLocation("quarryplus", "workbench_recipe");
    public static final WorkbenchRecipeSerializer SERIALIZER = new WorkbenchRecipeSerializer();
    public static final RecipeType<WorkbenchRecipe> RECIPE_TYPE = new WorkbenchRecipeType();
    @VisibleForTesting
    static RecipeFinder recipeFinder = new DefaultFinder();
    public static final Comparator<WorkbenchRecipe> COMPARATOR = Comparator.comparingLong(WorkbenchRecipe::getRequiredEnergy).thenComparingInt(r -> Item.m_41393_((Item)r.m_8043_().m_41720_())).thenComparing(WorkbenchRecipe::m_6423_);
    private final ResourceLocation location;
    private final ItemStack output;
    private final long energy;
    private final boolean showInJEI;

    public WorkbenchRecipe(ResourceLocation location, ItemStack output, long energy, boolean showInJEI) {
        this.location = location;
        this.output = output;
        this.energy = energy;
        this.showInJEI = showInJEI;
    }

    public String toString() {
        return "WorkbenchRecipe{id=" + this.location + ", output=" + this.output + ", energy=" + this.energy + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkbenchRecipe that = (WorkbenchRecipe)o;
        return this.energy == that.energy && this.location.equals((Object)that.location) && ItemStack.m_41746_((ItemStack)this.output, (ItemStack)that.output);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.energy);
    }

    public final long getRequiredEnergy() {
        return this.energy;
    }

    public final boolean showInJEI() {
        return this.showInJEI;
    }

    public final boolean matches(TileWorkbench workbench, Level level) {
        return this.hasContent() && this.hasAllRequiredItems(workbench.ingredientInventory);
    }

    public final ItemStack assemble(TileWorkbench workbench) {
        return this.getOutput(workbench.ingredientInventory);
    }

    public final boolean m_8004_(int width, int height) {
        return true;
    }

    public final ItemStack m_8043_() {
        return this.output;
    }

    public final ResourceLocation m_6423_() {
        return this.location;
    }

    public final RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public final RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public final boolean m_5598_() {
        return true;
    }

    public static WorkbenchRecipe dummyRecipe() {
        return DummyRecipe.INSTANCE;
    }

    public static RecipeFinder getRecipeFinder() {
        return recipeFinder;
    }

    public abstract List<IngredientList> inputs();

    public boolean hasContent() {
        return true;
    }

    protected abstract String getSubTypeName();

    protected abstract ItemStack getOutput(List<ItemStack> var1);

    protected boolean hasAllRequiredItems(List<ItemStack> inventory) {
        List<ItemStack> copied = inventory.stream().map(ItemStack::m_41777_).toList();
        for (IngredientList input : this.inputs()) {
            boolean found = copied.stream().anyMatch(input::shrink);
            if (found) continue;
            return false;
        }
        return copied.stream().allMatch(i -> i.m_41613_() >= 0);
    }

    public void consumeItems(List<ItemStack> inventory) {
        for (IngredientList input : this.inputs()) {
            for (ItemStack stack : inventory) {
                if (input.shrink(stack)) break;
            }
        }
    }

    private static final class WorkbenchRecipeType
    implements RecipeType<WorkbenchRecipe> {
        private WorkbenchRecipeType() {
        }

        public String toString() {
            return recipeLocation.toString();
        }
    }
}

