/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.filler.FillerEntity;
import com.yogpc.qp.machines.filler.FillerTargetPosIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class SkipIterator {
    FillerTargetPosIterator posIterator;
    List<BlockPos> skipped;
    private final Area area;

    public SkipIterator(Area area, Function<Area, FillerTargetPosIterator> constructor) {
        this.area = area;
        this.posIterator = constructor.apply(area);
        this.skipped = new ArrayList<BlockPos>();
    }

    @Nullable
    public BlockPos peek(Predicate<BlockPos> filter) {
        Optional<BlockPos> skipped = this.skipped.stream().filter(filter).findFirst();
        if (skipped.isPresent()) {
            return skipped.get();
        }
        while (this.posIterator.hasNext()) {
            BlockPos pos = (BlockPos)this.posIterator.peek();
            if (filter.test(pos)) {
                return pos;
            }
            this.commit(pos, true);
        }
        return null;
    }

    public void commit(BlockPos pos, boolean skip) {
        boolean alreadySkipped = this.skipped.remove(pos);
        if (skip) {
            this.skipped.add(pos);
        }
        if (!alreadySkipped) {
            this.posIterator.next();
        }
    }

    @VisibleForTesting
    @Nullable
    BlockPos next(Predicate<BlockPos> filter) {
        BlockPos pos = this.peek(filter);
        this.commit(pos, false);
        return pos;
    }

    CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.posIterator.type().name());
        tag.m_128365_("area", (Tag)this.area.toNBT());
        tag.m_128356_("current", ((BlockPos)this.posIterator.peek()).m_121878_());
        long[] skips = this.skipped.stream().mapToLong(BlockPos::m_121878_).toArray();
        tag.m_128388_("skips", skips);
        return tag;
    }

    static SkipIterator fromNbt(CompoundTag tag) {
        Area area = Area.fromNBT(tag.m_128469_("area")).orElseThrow(() -> new IllegalArgumentException("Invalid tag for SkipIterator. %s".formatted(tag)));
        FillerEntity.Action action = FillerEntity.Action.valueOf(tag.m_128461_("type"));
        SkipIterator skipIterator = new SkipIterator(area, action.iteratorProvider);
        BlockPos current = BlockPos.m_122022_((long)tag.m_128454_("current"));
        skipIterator.posIterator.setCurrent(current);
        Arrays.stream(tag.m_128467_("skips")).mapToObj(BlockPos::m_122022_).forEach(skipIterator.skipped::add);
        return skipIterator;
    }

    public String toString() {
        return "SkipIterator{area=%s, skipped=%d}".formatted(this.area, this.skipped.size());
    }
}

