/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.advquarry.AdvQuarry;
import com.yogpc.qp.machines.advquarry.AdvQuarryAction;
import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import com.yogpc.qp.machines.advquarry.WorkConfig;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.MapMulti;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public final class AdvActionMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final Area area;
    private final Actions action;
    private final WorkConfig workConfig;

    AdvActionMessage(TileAdvQuarry quarry, Actions action, Area area, WorkConfig workConfig) {
        this.pos = quarry.m_58899_();
        this.dim = PacketHandler.getDimension(quarry);
        this.area = area;
        this.action = action;
        this.workConfig = workConfig;
        AdvQuarry.LOGGER.debug(AdvQuarry.MESSAGE, "Message is created. {} {} {} {}", (Object)this.pos, (Object)this.dim.m_135782_(), (Object)this.area, (Object)this.action);
    }

    AdvActionMessage(TileAdvQuarry quarry, Actions action, Area area) {
        this(quarry, action, area, quarry.workConfig);
    }

    AdvActionMessage(TileAdvQuarry quarry, Actions action) {
        this(quarry, action, quarry.getArea(), quarry.workConfig);
    }

    AdvActionMessage(TileAdvQuarry quarry, Actions action, WorkConfig workConfig) {
        this(quarry, action, quarry.getArea(), workConfig);
    }

    public AdvActionMessage(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        this.area = Area.fromNBT(buf.m_130260_()).orElse(null);
        this.action = (Actions)buf.m_130066_(Actions.class);
        this.workConfig = new WorkConfig(buf);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos).m_130085_(this.dim.m_135782_());
        buf.m_130079_(this.area.toNBT());
        buf.m_130068_((Enum)this.action);
        this.workConfig.writePacket(buf);
    }

    public static void onReceive(AdvActionMessage message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> world = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> world.map(w -> w.m_7702_(message.pos)).flatMap(MapMulti.optCast(TileAdvQuarry.class)).ifPresent(arg_0 -> AdvActionMessage.lambda$onReceive$1(message, (Supplier)supplier, arg_0)));
    }

    private static /* synthetic */ void lambda$onReceive$1(AdvActionMessage message, Supplier supplier, TileAdvQuarry quarry) {
        AdvQuarry.LOGGER.debug(AdvQuarry.MESSAGE, "onReceive. {}, {}", (Object)message.pos, (Object)message.action);
        switch (message.action) {
            case CHANGE_RANGE: {
                quarry.setArea(message.area);
                break;
            }
            case MODULE_INV: {
                PacketHandler.getPlayer((NetworkEvent.Context)supplier.get()).flatMap(MapMulti.optCast(ServerPlayer.class)).ifPresent(quarry::openModuleGui);
                break;
            }
            case QUICK_START: {
                quarry.workConfig = quarry.workConfig.startSoonConfig();
                if (!quarry.canStartWork()) break;
                AdvQuarryAction.startQuarry(quarry);
                break;
            }
            case SYNC: {
                quarry.workConfig = message.workConfig;
            }
        }
    }

    static enum Actions {
        QUICK_START,
        MODULE_INV,
        CHANGE_RANGE,
        SYNC;

    }
}

