/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.gui.advancedInscriber;

import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.blockentity.misc.InscriberRecipes;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import io.github.projectet.ae2things.block.entity.BEAdvancedInscriber;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AdvancedInscriberMenu
extends UpgradeableMenu<BEAdvancedInscriber>
implements IProgressProvider,
IUpgradeableObject {
    public static MenuType<AdvancedInscriberMenu> ADVANCED_INSCRIBER_SHT = MenuTypeBuilder.create(AdvancedInscriberMenu::new, BEAdvancedInscriber.class).build("advanced_inscriber");
    private InternalInventory inventory;
    private Level world;
    private final Slot top;
    private final Slot middle;
    private final Slot bottom;
    @GuiSync(value=2)
    public int maxProcessingTime = -1;
    @GuiSync(value=3)
    public int processingTime = -1;

    public AdvancedInscriberMenu(int syncId, Inventory playerInventory, BEAdvancedInscriber advancedInscriber) {
        super(ADVANCED_INSCRIBER_SHT, syncId, playerInventory, (IUpgradeableObject)advancedInscriber);
        this.world = playerInventory.f_35978_.f_19853_;
        this.inventory = advancedInscriber.getInternalInventory();
        RestrictedInputSlot top = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.INSCRIBER_PLATE, this.inventory, 0);
        this.top = this.addSlot((Slot)top, SlotSemantics.INSCRIBER_PLATE_TOP);
        RestrictedInputSlot bottom = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.INSCRIBER_PLATE, this.inventory, 1);
        this.bottom = this.addSlot((Slot)bottom, SlotSemantics.INSCRIBER_PLATE_BOTTOM);
        RestrictedInputSlot middle = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.INSCRIBER_INPUT, this.inventory, 2);
        this.middle = this.addSlot((Slot)middle, SlotSemantics.MACHINE_INPUT);
        OutputSlot output = new OutputSlot(this.inventory, 3, null);
        this.addSlot((Slot)output, SlotSemantics.MACHINE_OUTPUT);
    }

    protected void standardDetectAndSendChanges() {
        if (this.isServerSide()) {
            this.maxProcessingTime = ((BEAdvancedInscriber)this.getHost()).getMaxProcessingTime();
            this.processingTime = ((BEAdvancedInscriber)this.getHost()).getProcessingTime();
        }
        super.standardDetectAndSendChanges();
    }

    public boolean isValidForSlot(Slot s, ItemStack is) {
        ItemStack top = this.inventory.getStackInSlot(0);
        ItemStack bot = this.inventory.getStackInSlot(1);
        if (s == this.middle) {
            ItemDefinition press = AEItems.NAME_PRESS;
            if (press.isSameAs(top) || press.isSameAs(bot)) {
                return !press.isSameAs(is);
            }
            return InscriberRecipes.findRecipe((Level)this.world, (ItemStack)is, (ItemStack)top, (ItemStack)bot, (boolean)false) != null;
        }
        if (s == this.top && !bot.m_41619_() || s == this.bottom && !top.m_41619_()) {
            ItemDefinition namePress = AEItems.NAME_PRESS;
            ItemStack otherSlot = s == this.top ? this.bottom.m_7993_() : this.top.m_7993_();
            if (namePress.isSameAs(otherSlot)) {
                return namePress.isSameAs(is);
            }
            return InscriberRecipes.isValidOptionalIngredientCombination((Level)this.world, (ItemStack)is, (ItemStack)otherSlot);
        }
        return true;
    }

    public int getCurrentProgress() {
        return this.processingTime;
    }

    public int getMaxProgress() {
        return this.maxProcessingTime;
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

