/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.screen.components.IToggleableButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.ScreenUtils;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class TogglePictureButton
extends ExtendedButton
implements IToggleableButton {
    private ResourceLocation textureLocation;
    private int[] u;
    private int[] v;
    private int currentIndex = 0;
    private final int toggleCount;
    private final int drawOffset;
    private final int drawWidth;
    private final int drawHeight;
    private final int uWidth;
    private final int vHeight;
    private final int textureWidth;
    private final int textureHeight;

    public TogglePictureButton(int xPos, int yPos, int width, int height, ResourceLocation texture, int[] textureX, int[] textureY, int drawOffset, int toggleCount, Button.OnPress onPress) {
        this(xPos, yPos, width, height, texture, textureX, textureY, drawOffset, 16, 16, 16, 16, 256, 256, toggleCount, onPress);
    }

    public TogglePictureButton(int xPos, int yPos, int width, int height, ResourceLocation texture, int[] textureX, int[] textureY, int drawOffset, int drawWidth, int drawHeight, int uWidth, int vHeight, int textureWidth, int textureHeight, int toggleCount, Button.OnPress onPress) {
        super(xPos, yPos, width, height, (Component)Component.m_237119_(), onPress);
        if (textureX.length != toggleCount || textureY.length != toggleCount) {
            throw new RuntimeException("TogglePictureButton was set up incorrectly. Array lengths must match toggleCount!");
        }
        this.textureLocation = texture;
        this.u = textureX;
        this.v = textureY;
        this.toggleCount = toggleCount;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.drawOffset = drawOffset;
        this.drawWidth = drawWidth;
        this.drawHeight = drawHeight;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            ScreenUtils.blitWithBorder((PoseStack)pose, (ResourceLocation)f_93617_, (int)this.f_93620_, (int)this.f_93621_, (int)0, (int)(46 + this.m_7202_(this.m_198029_()) * 20), (int)this.f_93618_, (int)this.f_93619_, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.m_93252_());
            if (this.getTextureLocation() != null) {
                RenderSystem.m_157179_((int)0, (ResourceLocation)this.getTextureLocation());
                TogglePictureButton.m_93160_((PoseStack)pose, (int)(this.f_93620_ + this.drawOffset), (int)(this.f_93621_ + this.drawOffset), (int)this.drawWidth, (int)this.drawHeight, (float)this.u[this.currentIndex], (float)this.v[this.currentIndex], (int)this.uWidth, (int)this.vHeight, (int)this.textureWidth, (int)this.textureHeight);
            }
        }
    }

    public void m_5691_() {
        if (Screen.m_96638_()) {
            this.setCurrentIndex(this.currentIndex - 1);
        } else {
            this.setCurrentIndex(this.currentIndex + 1);
        }
        super.m_5691_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.setCurrentIndex(this.currentIndex - (int)Math.signum(delta));
        this.f_93717_.m_93750_((Button)this);
        return true;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void setCurrentIndex(int newIndex) {
        this.currentIndex = Math.floorMod(newIndex, this.toggleCount);
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }
}

