/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.stream.Stream;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class TrophySystemBlock
extends DisguisableBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)6.5, (double)0.0, (double)12.0, (double)9.5, (double)1.5, (double)15.0), Block.m_49796_((double)5.5, (double)7.0, (double)5.5, (double)10.5, (double)11.0, (double)10.5), Block.m_49796_((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0), Block.m_49796_((double)6.5, (double)12.5, (double)6.5, (double)9.5, (double)15.0, (double)9.5), Block.m_49796_((double)7.0, (double)14.5, (double)7.0, (double)9.0, (double)15.5, (double)9.0), Block.m_49796_((double)7.25, (double)9.0, (double)7.25, (double)8.75, (double)12.0, (double)8.75), Block.m_49796_((double)1.0, (double)0.0, (double)6.5, (double)4.0, (double)1.5, (double)9.5), Block.m_49796_((double)12.0, (double)0.0, (double)6.5, (double)15.0, (double)1.5, (double)9.5), Block.m_49796_((double)6.5, (double)0.0, (double)1.0, (double)9.5, (double)1.5, (double)4.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83144_());

    public TrophySystemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return BlockUtils.isSideSolid(level, pos.m_7495_(), Direction.UP);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TrophySystemBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrophySystemBlockEntity && (be = (TrophySystemBlockEntity)blockEntity).isOwnedBy(player)) {
            if (!level.f_46443_) {
                if (be.isDisabled()) {
                    player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.TROPHY_SYSTEM, pos));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = TrophySystemBlock.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return SHAPE;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrophySystemBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TrophySystemBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.TROPHY_SYSTEM_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

