/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.AbstractKeypadFurnaceBlock;
import net.geforcemods.securitycraft.inventory.AbstractKeypadFurnaceMenu;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public abstract class AbstractKeypadFurnaceBlockEntity
extends AbstractFurnaceBlockEntity
implements IPasswordProtected,
MenuProvider,
IOwnable,
INameSetter,
IModuleInventory,
ICustomizable,
ILockable {
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private Owner owner = new Owner();
    private String passcode;
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption(() -> ((AbstractKeypadFurnaceBlockEntity)this).m_58899_());
    private long cooldownEnd = 0L;
    private EnumMap<ModuleType, Boolean> moduleStates = new EnumMap(ModuleType.class);
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            if (level.f_46443_) {
                return;
            }
            level.m_5898_(null, 1005, pos, 0);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)AbstractKeypadFurnaceBlock.OPEN, (Comparable)Boolean.valueOf(true)));
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            if (level.f_46443_) {
                return;
            }
            level.m_5898_(null, 1011, pos, 0);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)AbstractKeypadFurnaceBlock.OPEN, (Comparable)Boolean.valueOf(false)));
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int oldCount, int newCount) {
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof AbstractKeypadFurnaceMenu) {
                AbstractKeypadFurnaceMenu menu = (AbstractKeypadFurnaceMenu)abstractContainerMenu;
                AbstractKeypadFurnaceBlockEntity container = menu.be;
                return container == AbstractKeypadFurnaceBlockEntity.this;
            }
            return false;
        }
    };

    public AbstractKeypadFurnaceBlockEntity(BlockEntityType<?> beType, BlockPos pos, BlockState state, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(beType, pos, state, recipeType);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractKeypadFurnaceBlockEntity be) {
        if (!be.isDisabled()) {
            AbstractFurnaceBlockEntity.m_155013_((Level)level, (BlockPos)pos, (BlockState)state, (AbstractFurnaceBlockEntity)be);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        tag.m_128356_("cooldownLeft", this.getCooldownEnd() - System.currentTimeMillis());
        if (this.owner != null) {
            this.owner.save(tag, false);
        }
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
        this.cooldownEnd = System.currentTimeMillis() + tag.m_128454_("cooldownLeft");
        this.owner.load(tag);
        this.passcode = tag.m_128461_("passcode");
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.handleUpdateTag(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return BlockUtils.getProtectedCapability(side, (BlockEntity)this, () -> super.getCapability(cap, side), () -> this.getInsertOnlyHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        if (this.insertOnlyHandler != null) {
            this.insertOnlyHandler.invalidate();
        }
        super.invalidateCaps();
    }

    public void reviveCaps() {
        this.insertOnlyHandler = null;
        super.reviveCaps();
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this));
        }
        return this.insertOnlyHandler;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.f_58310_.get(slot);
    }

    @Override
    public boolean shouldAttemptCodebreak(BlockState state, Player player) {
        if (this.isDisabled()) {
            player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return IPasswordProtected.super.shouldAttemptCodebreak(state, player);
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof AbstractKeypadFurnaceBlock) {
            AbstractKeypadFurnaceBlock block2 = (AbstractKeypadFurnaceBlock)block;
            block2.activate(this, this.m_58900_(), this.f_58857_, this.f_58858_, player);
        }
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
        this.m_6596_();
    }

    public ContainerData getFurnaceData() {
        return this.f_58311_;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.m_6596_();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.disabled, this.smartModuleCooldown};
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted((BlockEntity)this, stack, toggled);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        DisguisableBlockEntity.onSetRemoved((BlockEntity)this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved((BlockEntity)this, stack, toggled);
        }
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData((BlockEntity)this);
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

