/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.FuelBurnTimeEvent;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ForgeEventFactory {
    public static BlockEvent.MultiPlaceEvent onPlayerMultiBlockPlace(yz player, List<BlockSnapshot> blockSnapshots, ForgeDirection direction) {
        aji placedAgainst = blockSnapshots.get((int)0).world.a(blockSnapshots.get((int)0).x + direction.getOpposite().offsetX, blockSnapshots.get((int)0).y + direction.getOpposite().offsetY, blockSnapshots.get((int)0).z + direction.getOpposite().offsetZ);
        BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(blockSnapshots, placedAgainst, player);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.PlaceEvent onPlayerBlockPlace(yz player, BlockSnapshot blockSnapshot, ForgeDirection direction) {
        aji placedAgainst = blockSnapshot.world.a(blockSnapshot.x + direction.getOpposite().offsetX, blockSnapshot.y + direction.getOpposite().offsetY, blockSnapshot.z + direction.getOpposite().offsetZ);
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blockSnapshot, placedAgainst, player);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static boolean doPlayerHarvestCheck(yz player, aji block, boolean success) {
        PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck(player, block, success);
        MinecraftForge.EVENT_BUS.post(event);
        return event.success;
    }

    @Deprecated
    public static float getBreakSpeed(yz player, aji block, int metadata, float original) {
        return ForgeEventFactory.getBreakSpeed(player, block, metadata, original, 0, -1, 0);
    }

    public static float getBreakSpeed(yz player, aji block, int metadata, float original, int x, int y2, int z2) {
        PlayerEvent.BreakSpeed event = new PlayerEvent.BreakSpeed(player, block, metadata, original, x, y2, z2);
        return MinecraftForge.EVENT_BUS.post(event) ? -1.0f : event.newSpeed;
    }

    @Deprecated
    public static PlayerInteractEvent onPlayerInteract(yz player, PlayerInteractEvent.Action action, int x, int y2, int z2, int face) {
        return ForgeEventFactory.onPlayerInteract(player, action, x, y2, z2, face, null);
    }

    public static PlayerInteractEvent onPlayerInteract(yz player, PlayerInteractEvent.Action action, int x, int y2, int z2, int face, ahb world) {
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, x, y2, z2, face, world);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static void onPlayerDestroyItem(yz player, add stack) {
        MinecraftForge.EVENT_BUS.post(new PlayerDestroyItemEvent(player, stack));
    }

    public static Event.Result canEntitySpawn(sw entity, ahb world, float x, float y2, float z2) {
        LivingSpawnEvent.CheckSpawn event = new LivingSpawnEvent.CheckSpawn(entity, world, x, y2, z2);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static boolean doSpecialSpawn(sw entity, ahb world, float x, float y2, float z2) {
        return MinecraftForge.EVENT_BUS.post(new LivingSpawnEvent.SpecialSpawn(entity, world, x, y2, z2));
    }

    public static Event.Result canEntityDespawn(sw entity) {
        LivingSpawnEvent.AllowDespawn event = new LivingSpawnEvent.AllowDespawn(entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static List<ahx> getPotentialSpawns(mt world, sx type, int x, int y2, int z2, List<ahx> oldList) {
        WorldEvent.PotentialSpawns event = new WorldEvent.PotentialSpawns((ahb)world, type, x, y2, z2, oldList);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.list;
    }

    public static int getFuelBurnTime(add fuel) {
        FuelBurnTimeEvent event = new FuelBurnTimeEvent(fuel);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult() == Event.Result.DEFAULT ? -1 : event.burnTime;
    }

    public static int getMaxSpawnPackSize(sw entity) {
        LivingPackSizeEvent maxCanSpawnEvent = new LivingPackSizeEvent(entity);
        MinecraftForge.EVENT_BUS.post(maxCanSpawnEvent);
        return maxCanSpawnEvent.getResult() == Event.Result.ALLOW ? maxCanSpawnEvent.maxPackSize : entity.bB();
    }

    public static String getPlayerDisplayName(yz player, String username) {
        PlayerEvent.NameFormat event = new PlayerEvent.NameFormat(player, username);
        MinecraftForge.EVENT_BUS.post(event);
        return event.displayname;
    }

    public static float fireBlockHarvesting(ArrayList<add> drops, ahb world, aji block, int x, int y2, int z2, int meta, int fortune, float dropChance, boolean silkTouch, yz player) {
        BlockEvent.HarvestDropsEvent event = new BlockEvent.HarvestDropsEvent(x, y2, z2, world, block, meta, fortune, dropChance, drops, player, silkTouch);
        MinecraftForge.EVENT_BUS.post(event);
        return event.dropChance;
    }

    public static ItemTooltipEvent onItemTooltip(add itemStack, yz entityPlayer, List<String> toolTip, boolean showAdvancedItemTooltips) {
        ItemTooltipEvent event = new ItemTooltipEvent(itemStack, entityPlayer, toolTip, showAdvancedItemTooltips);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static ZombieEvent.SummonAidEvent fireZombieSummonAid(yq zombie, ahb world, int x, int y2, int z2, sv attacker, double summonChance) {
        ZombieEvent.SummonAidEvent summonEvent = new ZombieEvent.SummonAidEvent(zombie, world, x, y2, z2, attacker, summonChance);
        MinecraftForge.EVENT_BUS.post(summonEvent);
        return summonEvent;
    }

    public static boolean onEntityStruckByLightning(sa entity, xh bolt) {
        return MinecraftForge.EVENT_BUS.post(new EntityStruckByLightningEvent(entity, bolt));
    }

    public static int onItemUseStart(yz player, add item, int duration) {
        PlayerUseItemEvent.Start event = new PlayerUseItemEvent.Start(player, item, duration);
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.duration;
    }

    public static int onItemUseTick(yz player, add item, int duration) {
        PlayerUseItemEvent.Tick event = new PlayerUseItemEvent.Tick(player, item, duration);
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.duration;
    }

    public static boolean onUseItemStop(yz player, add item, int duration) {
        return MinecraftForge.EVENT_BUS.post(new PlayerUseItemEvent.Stop(player, item, duration));
    }

    public static add onItemUseFinish(yz player, add item, int duration, add result) {
        PlayerUseItemEvent.Finish event = new PlayerUseItemEvent.Finish(player, item, duration, result);
        MinecraftForge.EVENT_BUS.post(event);
        return event.result;
    }

    public static void onStartEntityTracking(sa entity, yz player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StartTracking(player, entity));
    }

    public static void onStopEntityTracking(sa entity, yz player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StopTracking(player, entity));
    }

    public static void firePlayerLoadingEvent(yz player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerSavingEvent(yz player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.SaveToFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerLoadingEvent(yz player, azp playerFileData, String uuidString) {
        ayq sh = (ayq)playerFileData;
        File dir = (File)ObfuscationReflectionHelper.getPrivateValue(ayq.class, sh, "playersDirectory", "field_75771_c");
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, dir, uuidString));
    }

    public static boolean onExplosionStart(ahb world, agw explosion) {
        return MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Start(world, explosion));
    }

    public static void onExplosionDetonate(ahb world, agw explosion, List<sa> list, double diameter) {
        MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Detonate(world, explosion, list));
    }

    public static boolean onCreateWorldSpawn(ahb world, ahj settings) {
        return MinecraftForge.EVENT_BUS.post(new WorldEvent.CreateSpawnPosition(world, settings));
    }

    public static float onLivingHeal(sv entity, float amount) {
        LivingHealEvent event = new LivingHealEvent(entity, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.amount;
    }

    public static boolean onPotionAttemptBreaw(add[] stacks) {
        add[] tmp = new add[stacks.length];
        for (int x = 0; x < tmp.length; ++x) {
            tmp[x] = add.b((add)stacks[x]);
        }
        PotionBrewEvent.Pre event = new PotionBrewEvent.Pre(tmp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            boolean changed = false;
            for (int x = 0; x < stacks.length; ++x) {
                changed |= add.b((add)tmp[x], (add)stacks[x]);
                stacks[x] = event.getItem(x);
            }
            if (changed) {
                ForgeEventFactory.onPotionBrewed(stacks);
            }
            return true;
        }
        return false;
    }

    public static void onPotionBrewed(add[] brewingItemStacks) {
        MinecraftForge.EVENT_BUS.post(new PotionBrewEvent.Post(brewingItemStacks));
    }
}

