/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import cpw.mods.fml.client.IModGuiFactory;
import cpw.mods.fml.client.config.ConfigGuiType;
import cpw.mods.fml.client.config.DummyConfigElement;
import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Property;

public class ForgeGuiFactory
implements IModGuiFactory {
    @Override
    public void initialize(bao minecraftInstance) {
    }

    @Override
    public Class<? extends bdw> mainConfigGuiClass() {
        return ForgeConfigGui.class;
    }

    @Override
    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return null;
    }

    @Override
    public IModGuiFactory.RuntimeOptionGuiHandler getHandlerFor(IModGuiFactory.RuntimeOptionCategoryElement element) {
        return null;
    }

    public static class ForgeConfigGui
    extends GuiConfig {
        public ForgeConfigGui(bdw parentScreen) {
            super(parentScreen, ForgeConfigGui.getConfigElements(), "Forge", false, false, brp.a((String)"forge.configgui.forgeConfigTitle", (Object[])new Object[0]));
        }

        private static List<IConfigElement> getConfigElements() {
            ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
            list.add(new DummyConfigElement.DummyCategoryElement("forgeCfg", "forge.configgui.ctgy.forgeGeneralConfig", GeneralEntry.class));
            list.add(new DummyConfigElement.DummyCategoryElement("forgeChunkLoadingCfg", "forge.configgui.ctgy.forgeChunkLoadingConfig", ChunkLoaderEntry.class));
            return list;
        }

        public static class ModIDEntry
        extends GuiConfigEntries.SelectValueEntry {
            public ModIDEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop, ModIDEntry.getSelectableValues());
                if (this.selectableValues.size() == 0) {
                    this.btnValue.l = false;
                }
            }

            private static Map<Object, String> getSelectableValues() {
                TreeMap<Object, String> selectableValues = new TreeMap<Object, String>();
                for (ModContainer mod : Loader.instance().getActiveModList()) {
                    if (mod.isImmutable() || mod.getMod() == null) continue;
                    selectableValues.put(mod.getModId(), mod.getName());
                }
                return selectableValues;
            }

            @Override
            public void onGuiClosed() {
                Object modObject = Loader.instance().getModObjectList().get((Object)Loader.instance().getIndexedModList().get(this.currentValue));
                int maxTickets = 200;
                int maxChunks = 25;
                if (modObject != null) {
                    this.owningEntryList.saveConfigElements();
                    for (IConfigElement ice : this.owningScreen.configElements) {
                        if ("maximumTicketCount".equals(ice.getName())) {
                            maxTickets = Integer.valueOf(ice.get().toString());
                            continue;
                        }
                        if (!"maximumChunksPerTicket".equals(ice.getName())) continue;
                        maxChunks = Integer.valueOf(ice.get().toString());
                    }
                    ForgeChunkManager.addConfigProperty(modObject, "maximumTicketCount", String.valueOf(maxTickets), Property.Type.INTEGER);
                    ForgeChunkManager.addConfigProperty(modObject, "maximumChunksPerTicket", String.valueOf(maxChunks), Property.Type.INTEGER);
                    if (this.owningScreen.parentScreen instanceof GuiConfig) {
                        GuiConfig superParent = (GuiConfig)this.owningScreen.parentScreen;
                        ConfigCategory modCtgy = ForgeChunkManager.getConfigFor(modObject);
                        modCtgy.setPropertyOrder(ForgeChunkManager.MOD_PROP_ORDER);
                        ConfigElement modConfig = new ConfigElement(modCtgy);
                        boolean found = false;
                        for (IConfigElement ice : superParent.configElements) {
                            if (!ice.getName().equals(this.currentValue)) continue;
                            found = true;
                        }
                        if (!found) {
                            superParent.configElements.add(modConfig);
                        }
                        superParent.needsRefresh = true;
                        superParent.b();
                    }
                }
            }
        }

        public static class AddModOverrideEntry
        extends GuiConfigEntries.CategoryEntry {
            public AddModOverrideEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop);
            }

            @Override
            protected bdw buildChildScreen() {
                ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
                list.add(new DummyConfigElement<String>("modID", "", ConfigGuiType.STRING, "forge.configgui.modID").setCustomListEntryClass(ModIDEntry.class));
                list.add(new ConfigElement(new Property("maximumTicketCount", "200", Property.Type.INTEGER, "forge.configgui.maximumTicketCount")));
                list.add(new ConfigElement(new Property("maximumChunksPerTicket", "25", Property.Type.INTEGER, "forge.configgui.maximumChunksPerTicket")));
                return new GuiConfig((bdw)this.owningScreen, list, this.owningScreen.modID, this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, this.owningScreen.title, brp.a((String)"forge.configgui.ctgy.forgeChunkLoadingAddModConfig", (Object[])new Object[0]));
            }

            @Override
            public boolean isChanged() {
                return false;
            }
        }

        public static class ModOverridesEntry
        extends GuiConfigEntries.CategoryEntry {
            public ModOverridesEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop);
            }

            @Override
            protected bdw buildChildScreen() {
                ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
                list.add(new DummyConfigElement.DummyCategoryElement("addForgeChunkLoadingModCfg", "forge.configgui.ctgy.forgeChunkLoadingAddModConfig", AddModOverrideEntry.class));
                for (ConfigCategory cc : ForgeChunkManager.getModCategories()) {
                    list.add(new ConfigElement(cc));
                }
                return new GuiConfig((bdw)this.owningScreen, list, this.owningScreen.modID, this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, this.owningScreen.title, brp.a((String)"forge.configgui.ctgy.forgeChunkLoadingModConfig", (Object[])new Object[0]));
            }

            @Override
            public boolean enabled() {
                for (GuiConfigEntries.IConfigEntry entry : this.owningEntryList.listEntries) {
                    if (!entry.getName().equals("enabled") || !(entry instanceof GuiConfigEntries.BooleanEntry)) continue;
                    return Boolean.valueOf(entry.getCurrentValue().toString());
                }
                return true;
            }

            @Override
            public boolean isChanged() {
                if (this.childScreen instanceof GuiConfig) {
                    GuiConfig child = (GuiConfig)this.childScreen;
                    return child.entryList.listEntries.size() != child.initEntries.size() || child.entryList.hasChangedEntry(true);
                }
                return false;
            }

            @Override
            public void undoChanges() {
                if (this.childScreen instanceof GuiConfig) {
                    GuiConfig child = (GuiConfig)this.childScreen;
                    for (GuiConfigEntries.IConfigEntry ice : child.entryList.listEntries) {
                        if (child.initEntries.contains(ice) || !ForgeChunkManager.getConfig().hasCategory(ice.getName())) continue;
                        ForgeChunkManager.getConfig().removeCategory(ForgeChunkManager.getConfig().getCategory(ice.getName()));
                    }
                    child.entryList.listEntries = new ArrayList<GuiConfigEntries.IConfigEntry>(child.initEntries);
                }
            }
        }

        public static class ChunkLoaderEntry
        extends GuiConfigEntries.CategoryEntry {
            public ChunkLoaderEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop);
            }

            @Override
            protected bdw buildChildScreen() {
                ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
                list.add(new DummyConfigElement.DummyCategoryElement("forgeChunkLoadingModCfg", "forge.configgui.ctgy.forgeChunkLoadingModConfig", ModOverridesEntry.class));
                list.addAll(new ConfigElement(ForgeChunkManager.getDefaultsCategory()).getChildElements());
                return new GuiConfig(this.owningScreen, list, this.owningScreen.modID, "chunkLoader", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, GuiConfig.getAbridgedConfigPath(ForgeChunkManager.getConfig().toString()), brp.a((String)"forge.configgui.ctgy.forgeChunkLoadingConfig", (Object[])new Object[0]));
            }
        }

        public static class GeneralEntry
        extends GuiConfigEntries.CategoryEntry {
            public GeneralEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop);
            }

            @Override
            protected bdw buildChildScreen() {
                return new GuiConfig((bdw)this.owningScreen, new ConfigElement(ForgeModContainer.getConfig().getCategory("general")).getChildElements(), this.owningScreen.modID, "general", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, GuiConfig.getAbridgedConfigPath(ForgeModContainer.getConfig().toString()));
            }
        }
    }
}

