/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;

@Cancelable
public class ServerChatEvent
extends Event {
    private final ServerPlayer player;
    private final String username;
    private final String rawText;
    private final boolean canChangeMessage;
    private Component message;

    @ApiStatus.Internal
    protected ServerChatEvent(ServerPlayer player, String rawText, Component message, boolean canChangeMessage) {
        this.player = player;
        this.username = player.m_36316_().getName();
        this.rawText = rawText;
        this.canChangeMessage = canChangeMessage;
        this.message = message;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRawText() {
        return this.rawText;
    }

    public boolean canChangeMessage() {
        return this.canChangeMessage;
    }

    public void setMessage(Component message) {
        if (!this.canChangeMessage) {
            return;
        }
        this.message = Objects.requireNonNull(message);
    }

    public Component getMessage() {
        return this.message;
    }

    public static class Submitted
    extends ServerChatEvent {
        @ApiStatus.Internal
        public Submitted(ServerPlayer player, String rawText, Component message, boolean canChangeMessage) {
            super(player, rawText, message, canChangeMessage);
        }
    }

    public static class Preview
    extends ServerChatEvent {
        @ApiStatus.Internal
        public Preview(ServerPlayer player, String rawText, Component message) {
            super(player, rawText, message, true);
        }

        @Override
        public void setMessage(Component message) {
            super.setMessage(message);
        }

        @Override
        public Component getMessage() {
            return super.getMessage();
        }
    }
}

